---@meta

---@class FConcertAuthorityClientInfo
---@field StreamId FGuid
---@field AuthoredObjects TArray<FSoftObjectPath>
local FConcertAuthorityClientInfo = {}



---@class FConcertBaseStreamInfo
---@field Identifier FGuid
---@field ReplicationMap FConcertObjectReplicationMap
---@field FrequencySettings FConcertStreamFrequencySettings
local FConcertBaseStreamInfo = {}



---@class FConcertClientDesktopPresenceUpdateEvent : FConcertClientPresenceEventBase
---@field TraceStart FVector
---@field TraceEnd FVector
---@field bMovingCamera boolean
local FConcertClientDesktopPresenceUpdateEvent = {}



---@class FConcertClientPresenceDataUpdateEvent : FConcertClientPresenceEventBase
---@field WorldPath FName
---@field Position FVector
---@field orientation FQuat
---@field PresenceType EPresenceModeType
local FConcertClientPresenceDataUpdateEvent = {}



---@class FConcertClientPresenceEventBase
---@field TransactionUpdateIndex uint32
local FConcertClientPresenceEventBase = {}



---@class FConcertClientPresenceInVREvent
---@field VRDevice FName
local FConcertClientPresenceInVREvent = {}



---@class FConcertClientPresenceVisibilityUpdateEvent
---@field ModifiedEndpointId FGuid
---@field bVisibility boolean
local FConcertClientPresenceVisibilityUpdateEvent = {}



---@class FConcertClientVRPresenceUpdateEvent : FConcertClientPresenceEventBase
---@field LeftMotionControllerPosition FVector
---@field LeftMotionControllerOrientation FQuat
---@field RightMotionControllerPosition FVector
---@field RightMotionControllerOrientation FQuat
---@field Lasers FConcertLaserData
local FConcertClientVRPresenceUpdateEvent = {}



---@class FConcertDataStore_CompareExchangeRequest : FConcertDataStore_Request
---@field ExpectedVersion uint32
---@field Expected FConcertSessionSerializedPayload
---@field Desired FConcertSessionSerializedPayload
local FConcertDataStore_CompareExchangeRequest = {}



---@class FConcertDataStore_Double
---@field Value double
local FConcertDataStore_Double = {}



---@class FConcertDataStore_FetchOrAddRequest : FConcertDataStore_Request
---@field SerializedValue FConcertSessionSerializedPayload
local FConcertDataStore_FetchOrAddRequest = {}



---@class FConcertDataStore_Integer
---@field Value uint64
local FConcertDataStore_Integer = {}



---@class FConcertDataStore_KeyValuePair
---@field Key FName
---@field Value FConcertDataStore_StoreValue
local FConcertDataStore_KeyValuePair = {}



---@class FConcertDataStore_ReplicateEvent
---@field Values TArray<FConcertDataStore_KeyValuePair>
local FConcertDataStore_ReplicateEvent = {}



---@class FConcertDataStore_Request
---@field Key FName
---@field TypeName FName
local FConcertDataStore_Request = {}



---@class FConcertDataStore_Response
---@field ResultCode EConcertDataStoreResultCode
---@field Value FConcertDataStore_StoreValue
local FConcertDataStore_Response = {}



---@class FConcertDataStore_StoreValue
---@field TypeName FName
---@field Version uint32
---@field SerializedValue FConcertSessionSerializedPayload
local FConcertDataStore_StoreValue = {}



---@class FConcertDataStore_String
---@field Value FString
local FConcertDataStore_String = {}



---@class FConcertDataStore_Text
---@field Value FText
local FConcertDataStore_Text = {}



---@class FConcertExportedObject
---@field ObjectId FConcertObjectId
---@field ObjectPathDepth int32
---@field bHasLevelInstanceObject boolean
---@field ObjectData FConcertSerializedObjectData
---@field PropertyDatas TArray<FConcertSerializedPropertyData>
---@field SerializedAnnotationData TArray<uint8>
local FConcertExportedObject = {}



---@class FConcertIgnoreActivityStateChangedEvent
---@field EndpointId FGuid
---@field bIgnore boolean
local FConcertIgnoreActivityStateChangedEvent = {}



---@class FConcertLaserData
---@field LaserStart FVector
---@field LaserEnd FVector
local FConcertLaserData = {}



---@class FConcertObjectId
---@field ObjectClassPathName FName
---@field ObjectPackageName FName
---@field ObjectName FName
---@field ObjectOuterPathName FName
---@field ObjectExternalPackageName FName
---@field ObjectPersistentFlags uint32
local FConcertObjectId = {}



---@class FConcertObjectInStreamID
---@field StreamId FGuid
---@field Object FSoftObjectPath
local FConcertObjectInStreamID = {}



---@class FConcertObjectReplicationMap
---@field ReplicatedObjects TMap<FSoftObjectPath, FConcertReplicatedObjectInfo>
local FConcertObjectReplicationMap = {}



---@class FConcertObjectReplicationSettings
---@field ReplicationMode EConcertObjectReplicationMode
---@field ReplicationRate uint8
local FConcertObjectReplicationSettings = {}



---@class FConcertPackage
---@field Info FConcertPackageInfo
---@field PackageData FConcertByteArray
---@field fileId FString
local FConcertPackage = {}



---@class FConcertPackageInfo
---@field PackageName FName
---@field NewPackageName FName
---@field AssetClass FString
---@field PackageFileExtension FString
---@field PackageUpdateType EConcertPackageUpdateType
---@field TransactionEventIdAtSave int64
---@field bPreSave boolean
---@field bAutoSave boolean
local FConcertPackageInfo = {}



---@class FConcertPackageRejectedEvent
---@field PackageName FName
local FConcertPackageRejectedEvent = {}



---@class FConcertPackageTransmissionStartEvent
---@field TransmissionId FGuid
---@field PackageInfo FConcertPackageInfo
---@field PackageNumBytes uint64
local FConcertPackageTransmissionStartEvent = {}



---@class FConcertPackageUpdateEvent
---@field TransmissionId FGuid
---@field Package FConcertPackage
local FConcertPackageUpdateEvent = {}



---@class FConcertPlaySessionEvent
---@field EventType EConcertPlaySessionEventType
---@field PlayEndpointId FGuid
---@field PlayPackageName FName
---@field bIsSimulating boolean
local FConcertPlaySessionEvent = {}



---@class FConcertPropertyChain
---@field PathToProperty TArray<FName>
local FConcertPropertyChain = {}



---@class FConcertPropertySelection
---@field ReplicatedProperties TArray<FConcertPropertyChain>
local FConcertPropertySelection = {}



---@class FConcertQueriedClientInfo
---@field Streams TArray<FConcertBaseStreamInfo>
---@field Authority TArray<FConcertAuthorityClientInfo>
local FConcertQueriedClientInfo = {}



---@class FConcertReplicatedObjectId : FConcertObjectInStreamID
local FConcertReplicatedObjectId = {}


---@class FConcertReplicatedObjectInfo
---@field ClassPath FSoftClassPath
---@field PropertySelection FConcertPropertySelection
local FConcertReplicatedObjectInfo = {}



---@class FConcertReplicationStream
---@field BaseDescription FConcertBaseStreamInfo
local FConcertReplicationStream = {}



---@class FConcertReplication_BatchReplicationEvent
---@field Streams TArray<FConcertReplication_StreamReplicationEvent>
local FConcertReplication_BatchReplicationEvent = {}



---@class FConcertReplication_ChangeAuthority_Request
---@field TakeAuthority TMap<FSoftObjectPath, FConcertStreamArray>
---@field ReleaseAuthority TMap<FSoftObjectPath, FConcertStreamArray>
local FConcertReplication_ChangeAuthority_Request = {}



---@class FConcertReplication_ChangeAuthority_Response
---@field errorCode EReplicationResponseErrorCode
---@field RejectedObjects TMap<FSoftObjectPath, FConcertStreamArray>
local FConcertReplication_ChangeAuthority_Response = {}



---@class FConcertReplication_ChangeStream_Frequency
---@field OverridesToPut TMap<FSoftObjectPath, FConcertObjectReplicationSettings>
---@field OverridesToRemove TSet<FSoftObjectPath>
---@field OverridesToAdd TMap<FSoftObjectPath, FConcertObjectReplicationSettings>
---@field NewDefaults FConcertObjectReplicationSettings
---@field Flags EConcertReplicationChangeFrequencyFlags
local FConcertReplication_ChangeStream_Frequency = {}



---@class FConcertReplication_ChangeStream_FrequencyResponse
---@field OverrideFailures TMap<FConcertObjectInStreamID, EConcertChangeObjectFrequencyErrorCode>
---@field DefaultFailures TMap<FGuid, EConcertChangeStreamFrequencyErrorCode>
local FConcertReplication_ChangeStream_FrequencyResponse = {}



---@class FConcertReplication_ChangeStream_PutObject
---@field Properties FConcertPropertySelection
---@field ClassPath FSoftClassPath
local FConcertReplication_ChangeStream_PutObject = {}



---@class FConcertReplication_ChangeStream_Request
---@field ObjectsToRemove TSet<FConcertObjectInStreamID>
---@field ObjectsToPut TMap<FConcertObjectInStreamID, FConcertReplication_ChangeStream_PutObject>
---@field FrequencyChanges TMap<FGuid, FConcertReplication_ChangeStream_Frequency>
---@field StreamsToAdd TArray<FConcertReplicationStream>
---@field StreamsToRemove TSet<FGuid>
local FConcertReplication_ChangeStream_Request = {}



---@class FConcertReplication_ChangeStream_Response
---@field errorCode EReplicationResponseErrorCode
---@field AuthorityConflicts TMap<FConcertObjectInStreamID, FConcertReplicatedObjectId>
---@field ObjectsToPutSemanticErrors TMap<FConcertObjectInStreamID, EConcertPutObjectErrorCode>
---@field FailedStreamCreation TSet<FGuid>
---@field FrequencyErrors FConcertReplication_ChangeStream_FrequencyResponse
local FConcertReplication_ChangeStream_Response = {}



---@class FConcertReplication_Join_Request
---@field Streams TArray<FConcertReplicationStream>
local FConcertReplication_Join_Request = {}



---@class FConcertReplication_Join_Response
---@field JoinErrorCode EJoinReplicationErrorCode
---@field DetailedErrorMessage FString
local FConcertReplication_Join_Response = {}



---@class FConcertReplication_LeaveEvent
local FConcertReplication_LeaveEvent = {}


---@class FConcertReplication_ObjectReplicationEvent
---@field ReplicatedObject FSoftObjectPath
---@field SerializedPayload FConcertSessionSerializedPayload
local FConcertReplication_ObjectReplicationEvent = {}



---@class FConcertReplication_QueryReplicationInfo_Request
---@field ClientEndpointIds TSet<FGuid>
---@field QueryFlags EConcertQueryClientStreamFlags
local FConcertReplication_QueryReplicationInfo_Request = {}



---@class FConcertReplication_QueryReplicationInfo_Response
---@field errorCode EReplicationResponseErrorCode
---@field ClientInfo TMap<FGuid, FConcertQueriedClientInfo>
local FConcertReplication_QueryReplicationInfo_Response = {}



---@class FConcertReplication_StreamReplicationEvent
---@field StreamId FGuid
---@field ReplicatedObjects TArray<FConcertReplication_ObjectReplicationEvent>
local FConcertReplication_StreamReplicationEvent = {}



---@class FConcertResourceLockEvent
---@field ClientId FGuid
---@field ResourceNames TArray<FName>
---@field LockType EConcertResourceLockType
local FConcertResourceLockEvent = {}



---@class FConcertResourceLockRequest
---@field ClientId FGuid
---@field ResourceNames TArray<FName>
---@field LockType EConcertResourceLockType
local FConcertResourceLockRequest = {}



---@class FConcertResourceLockResponse
---@field FailedResources TMap<FName, FGuid>
---@field LockType EConcertResourceLockType
local FConcertResourceLockResponse = {}



---@class FConcertSequencerCloseEvent
---@field SequenceObjectPath FString
---@field bControllerClose boolean
---@field EditorsWithSequencerOpened int32
local FConcertSequencerCloseEvent = {}



---@class FConcertSequencerOpenEvent
---@field SequenceObjectPath FString
---@field TakeData FConcertByteArray
local FConcertSequencerOpenEvent = {}



---@class FConcertSequencerPreloadAssetStatusMap
---@field Sequences TMap<FTopLevelAssetPath, EConcertSequencerPreloadStatus>
local FConcertSequencerPreloadAssetStatusMap = {}



---@class FConcertSequencerPreloadClientStatusMap
---@field ClientEndpoints TMap<FGuid, FConcertSequencerPreloadAssetStatusMap>
local FConcertSequencerPreloadClientStatusMap = {}



---@class FConcertSequencerPreloadRequest
---@field SequenceObjectPaths TArray<FTopLevelAssetPath>
---@field bShouldBePreloaded boolean
local FConcertSequencerPreloadRequest = {}



---@class FConcertSequencerState
---@field SequenceObjectPath FString
---@field Time FQualifiedFrameTime
---@field PlayerStatus EConcertMovieScenePlayerStatus
---@field PlaybackRange FFrameNumberRange
---@field PlaybackSpeed float
---@field bLoopMode boolean
---@field TakeData FConcertByteArray
local FConcertSequencerState = {}



---@class FConcertSequencerStateEvent
---@field State FConcertSequencerState
local FConcertSequencerStateEvent = {}



---@class FConcertSequencerStateSyncEvent
---@field SequencerStates TArray<FConcertSequencerState>
local FConcertSequencerStateSyncEvent = {}



---@class FConcertSequencerTimeAdjustmentEvent
---@field PlaybackStartFrame FFrameNumber
---@field SequenceObjectPath FString
local FConcertSequencerTimeAdjustmentEvent = {}



---@class FConcertSerializedObjectData
---@field bAllowCreate boolean
---@field bResetExisting boolean
---@field bIsPendingKill boolean
---@field NewPackageName FName
---@field NewName FName
---@field NewOuterPathName FName
---@field NewExternalPackageName FName
---@field SerializedData TArray<uint8>
local FConcertSerializedObjectData = {}



---@class FConcertSerializedPropertyData
---@field PropertyName FName
---@field SerializedData TArray<uint8>
local FConcertSerializedPropertyData = {}



---@class FConcertServerLogging
---@field bLoggingEnabled boolean
local FConcertServerLogging = {}



---@class FConcertStreamArray
---@field StreamIds TArray<FGuid>
local FConcertStreamArray = {}



---@class FConcertStreamFrequencySettings
---@field Defaults FConcertObjectReplicationSettings
---@field ObjectOverrides TMap<FSoftObjectPath, FConcertObjectReplicationSettings>
local FConcertStreamFrequencySettings = {}



---@class FConcertSyncActivity
---@field ActivityId int64
---@field bIgnored boolean
---@field Flags EConcertSyncActivityFlags
---@field EndpointId FGuid
---@field EventTime FDateTime
---@field EventType EConcertSyncActivityEventType
---@field EventId int64
---@field EventSummary FConcertSessionSerializedPayload
local FConcertSyncActivity = {}



---@class FConcertSyncActivitySummary
local FConcertSyncActivitySummary = {}


---@class FConcertSyncConnectionActivity : FConcertSyncActivity
---@field EventData FConcertSyncConnectionEvent
local FConcertSyncConnectionActivity = {}



---@class FConcertSyncConnectionActivitySummary : FConcertSyncActivitySummary
---@field ConnectionEventType EConcertSyncConnectionEventType
local FConcertSyncConnectionActivitySummary = {}



---@class FConcertSyncConnectionEvent
---@field ConnectionEventType EConcertSyncConnectionEventType
local FConcertSyncConnectionEvent = {}



---@class FConcertSyncEndpointData
---@field ClientInfo FConcertClientInfo
local FConcertSyncEndpointData = {}



---@class FConcertSyncEndpointIdAndData
---@field EndpointId FGuid
---@field EndpointData FConcertSyncEndpointData
local FConcertSyncEndpointIdAndData = {}



---@class FConcertSyncEventRequest
---@field EventType EConcertSyncActivityEventType
---@field EventId int64
local FConcertSyncEventRequest = {}



---@class FConcertSyncEventResponse
---@field Event FConcertSessionSerializedPayload
local FConcertSyncEventResponse = {}



---@class FConcertSyncLockActivity : FConcertSyncActivity
---@field EventData FConcertSyncLockEvent
local FConcertSyncLockActivity = {}



---@class FConcertSyncLockActivitySummary : FConcertSyncActivitySummary
---@field LockEventType EConcertSyncLockEventType
---@field PrimaryResourceName FName
---@field PrimaryPackageName FName
---@field NumResources int32
local FConcertSyncLockActivitySummary = {}



---@class FConcertSyncLockEvent
---@field LockEventType EConcertSyncLockEventType
---@field ResourceNames TArray<FName>
local FConcertSyncLockEvent = {}



---@class FConcertSyncPackageActivity : FConcertSyncActivity
---@field EventData FConcertSyncPackageEvent
local FConcertSyncPackageActivity = {}



---@class FConcertSyncPackageActivitySummary : FConcertSyncActivitySummary
---@field PackageName FName
---@field NewPackageName FName
---@field PackageUpdateType EConcertPackageUpdateType
---@field bAutoSave boolean
---@field bPreSave boolean
local FConcertSyncPackageActivitySummary = {}



---@class FConcertSyncPackageEvent
---@field PackageRevision int64
---@field Package FConcertPackage
local FConcertSyncPackageEvent = {}



---@class FConcertSyncPackageEventMetaData
---@field PackageRevision int64
---@field PackageInfo FConcertPackageInfo
local FConcertSyncPackageEventMetaData = {}



---@class FConcertSyncTransactionActivity : FConcertSyncActivity
---@field EventData FConcertSyncTransactionEvent
local FConcertSyncTransactionActivity = {}



---@class FConcertSyncTransactionActivitySummary : FConcertSyncActivitySummary
---@field TransactionSummaryType EConcertSyncTransactionActivitySummaryType
---@field TransactionTitle FText
---@field PrimaryObjectName FName
---@field PrimaryPackageName FName
---@field NewObjectName FName
---@field NumActions int32
local FConcertSyncTransactionActivitySummary = {}



---@class FConcertSyncTransactionEvent
---@field Transaction FConcertTransactionFinalizedEvent
local FConcertSyncTransactionEvent = {}



---@class FConcertTransactionEventBase
---@field transactionId FGuid
---@field OperationId FGuid
---@field TransactionEndpointId FGuid
---@field TransactionUpdateIndex uint8
---@field VersionIndex int32
---@field ModifiedPackages TArray<FName>
---@field PrimaryObjectId FConcertObjectId
---@field ExportedObjects TArray<FConcertExportedObject>
local FConcertTransactionEventBase = {}



---@class FConcertTransactionFinalizedEvent : FConcertTransactionEventBase
---@field LocalIdentifierState FConcertLocalIdentifierState
---@field Title FText
local FConcertTransactionFinalizedEvent = {}



---@class FConcertTransactionRejectedEvent
---@field transactionId FGuid
local FConcertTransactionRejectedEvent = {}



---@class FConcertTransactionSnapshotEvent : FConcertTransactionEventBase
local FConcertTransactionSnapshotEvent = {}


---@class FConcertWorkspaceSyncActivityEvent : FConcertWorkspaceSyncEventBase
---@field Activity FConcertSessionSerializedPayload
local FConcertWorkspaceSyncActivityEvent = {}



---@class FConcertWorkspaceSyncAndFinalizeCompletedEvent
local FConcertWorkspaceSyncAndFinalizeCompletedEvent = {}


---@class FConcertWorkspaceSyncCompletedEvent
local FConcertWorkspaceSyncCompletedEvent = {}


---@class FConcertWorkspaceSyncEndpointEvent : FConcertWorkspaceSyncEventBase
---@field Endpoint FConcertSyncEndpointIdAndData
local FConcertWorkspaceSyncEndpointEvent = {}



---@class FConcertWorkspaceSyncEventBase
---@field NumRemainingSyncEvents int32
local FConcertWorkspaceSyncEventBase = {}



---@class FConcertWorkspaceSyncLockEvent : FConcertWorkspaceSyncEventBase
---@field LockedResources TMap<FName, FGuid>
local FConcertWorkspaceSyncLockEvent = {}



---@class FConcertWorkspaceSyncRequestedEvent
---@field FirstActivityIdToSync int64
---@field LastActivityIdToSync int64
---@field bEnableLiveSync boolean
local FConcertWorkspaceSyncRequestedEvent = {}



---@class FFullObjectReplicationData
---@field SerializedObjectData FConcertByteArray
local FFullObjectReplicationData = {}



---@class FPackageClassFilter
---@field AssetClass FSoftClassPath
---@field ContentPaths TArray<FString>
local FPackageClassFilter = {}



---@class FTransactionClassFilter
---@field ObjectOuterClass FSoftClassPath
---@field ObjectClasses TArray<FSoftClassPath>
local FTransactionClassFilter = {}



---@class UConcertSyncConfig : UObject
---@field bInteractiveHotReload boolean
---@field bShowPresenceInPIE boolean
---@field bIncludeAnnotationObjectChanges boolean
---@field SnapshotTransactionsPerSecond float
---@field IncludeObjectClassFilters TArray<FTransactionClassFilter>
---@field ExcludeTransactionClassFilters TArray<FTransactionClassFilter>
---@field AllowedTransientProperties TArray<TFieldPath<FProperty>>
---@field ExcludedProperties TArray<TFieldPath<FProperty>>
---@field ExcludedPropertyTypes TArray<FName>
---@field ExcludePackageClassFilters TArray<FPackageClassFilter>
local UConcertSyncConfig = {}



